DROP TABLE IF EXISTS w_g_reset_data;

create table W_G_RESET_DATA (
       HLR_INDEX         int      NOT NULL,
       VLRSGSN_NUMBER    CHAR(40)    NOT NULL,
       VLRSGSN_MODE      int      NOT NULL
  )WITH (fillfactor=85);

CREATE UNIQUE INDEX XPKW_G_RESET_DATA ON W_G_RESET_DATA
(
        HLR_INDEX,
        VLRSGSN_NUMBER,
        VLRSGSN_MODE
)WITH (fillfactor=95);

CREATE OR REPLACE FUNCTION insert() returns int as $$
DECLARE
	i int;
	k int;
BEGIN
	FOR i in 1..500000 LOOP
	insert into W_G_RESET_DATA values (i, 'a', random()*100);
	END LOOP;
	return 1;
END;
$$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION update_inc(i int) returns int as $$
BEGIN
        update W_G_RESET_DATA set HLR_INDEX = HLR_INDEX + 500000 where HLR_INDEX >= (100000 * i) and HLR_INDEX < (100000 * (i + 1));
        return 1;
END;
$$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION update_dec(i int) returns int as $$
BEGIN
        update W_G_RESET_DATA set HLR_INDEX = HLR_INDEX - 500000 where HLR_INDEX >= (1000000 * i) and HLR_INDEX < (1000000 * (i + 1));
        return 1;
END;
$$ LANGUAGE plpgsql;

drop table if exists tbl;
create table tbl (fld int);
insert into tbl values (1);

