 select testname,
       (compresstest(data, niters, 8192)::numeric / 1000)::numeric(10,3) as hs8192,
       (compresstest(data, niters, 4096)::numeric / 1000)::numeric(10,3) as hs4096,
       (compresstest(data, niters, 2048)::numeric / 1000)::numeric(10,3) as hs2048,
       (compresstest(data, niters, 1024)::numeric / 1000)::numeric(10,3) as hs1024,
       (compresstest(data, niters, 512)::numeric / 1000)::numeric(10,3) as hs512,
       (compresstest(data, niters, 256)::numeric / 1000)::numeric(10,3) as hs256,
       (compresstest(data, niters, 128)::numeric / 1000)::numeric(10,3) as hs128
from tests;

select datatype, datalen, hsize, compresstest(substr(data, 0, datalen), (10000000 / datalen::numeric)::int4, hsize)
from
(select round(10^(x::numeric / 4))::int4 as datalen from generate_series(4, 20) x) as lens,
(select 'text' as datatype, data from tests where testname='100k text'
 union all
 select 'random' as datatype, data from tests where testname='100k random') as datatypes,
(values (512), (1024), (2048), (4096), (8192), (16384)) as hsize (hsize)
order by datatype, datalen, hsize;