/* Including "our" library */
#include "orapg.h"

/* connecting to the database */
sqlo_db_handle_t oraconnect(char *login)
{
	sqlo_db_handle_t mydbh;
	
  	/* init */
 	if 	(SQLO_SUCCESS != sqlo_init(SQLO_OFF, 1, 100)) 
	{
    		elog(ERROR, "Failed to init libsqlora8\n");
  	}

  	/* login */
  	if 	(SQLO_SUCCESS != sqlo_connect(&mydbh, login)) 
	{
    		elog(ERROR, "Cannot login with %s\n", login);
  	}

	return mydbh;
}

/* perform a query and return the statement handle */
sqlo_stmt_handle_t oraquery(char *statement)
{
	sqlo_stmt_handle_t mysth;
	
	if	(strlen(statement) < 1)
	{
		elog(ERROR, "No query provided");
	}
	
	if 	( 0 > (sqlo_open2(&mysth, dbh,
	        statement, 0, NULL))) 
	{
		elog(ERROR, "Cannot perform query. Maybe you have encountered a syntax error or you have not connected to Oracle yet");
	}

  	/* get the output column names */
  	n = sqlo_ocol_names(mysth, &nc);

  	/* get the output column name lengths */
  	nl = sqlo_ocol_name_lens(mysth, NULL);

	elog(NOTICE, "SQL statement successful");

	return mysth;
}

/* run an SQL statement on the remote machine */
PG_FUNCTION_INFO_V1(dblink_oraexec);
Datum dblink_oraexec(PG_FUNCTION_ARGS)
{
	char *statement = GET_STR(PG_GETARG_TEXT_P(0));
	int affected = 0;		/* number of rows effected by the statement */

	affected = sqlo_exec(dbh, statement);
	elog(NOTICE, "Affected: %d", affected);
	if	(affected < 0)
	{
		elog(ERROR, "Cannot execute SQL statement");
	}

	PG_RETURN_INT32(affected);
}

/* PostgreSQL wrapper for connect function */
/* With the help of this function it is possible to connect to
 * an Oracle database and to leave the connection open */
PG_FUNCTION_INFO_V1(dblink_oraconnect);
Datum dblink_oraconnect(PG_FUNCTION_ARGS)
{
	char *login = GET_STR(PG_GETARG_TEXT_P(0));
	text *result_text;

	/* connecting to the database
	 * dbh is a global variable so we don't have to worry
	 * about it too much */
	dbh = oraconnect(login);
	
	/* compiling the result */
        result_text = DatumGetTextP(DirectFunctionCall1(textin, CStringGetDatum("OK")));
        PG_RETURN_TEXT_P(result_text);
}

/* PostgreSQL wrapper around the disconnect function */
PG_FUNCTION_INFO_V1(dblink_oradisconnect);
Datum dblink_oradisconnect(PG_FUNCTION_ARGS)
{
	text *result_text;
	sqlo_finish(dbh);
        result_text = DatumGetTextP(DirectFunctionCall1(textin, CStringGetDatum("OK")));
        PG_RETURN_TEXT_P(result_text);
}
	
/* Defining server side function for Oracle */
PG_FUNCTION_INFO_V1(dblink_ora);
Datum dblink_ora(PG_FUNCTION_ARGS)
{
	FuncCallContext 	*funcctx;
	TupleDesc		tupdesc = NULL;
	int			call_cntr = 0;
	TupleTableSlot 		*slot;
        AttInMetadata 		*attinmeta;

	char *query = GET_STR(PG_GETARG_TEXT_P(0));

	int i = 0;				/* used inside a loop */
  	int status;                   		/* status of sqlo calls */
  	const char ** v;              		/* values */
  	const unsigned short *vl;     		/* value lengths */
	
	char pgcolname[COLLEN];			/* name used to data structure created by this function */
	int tmp;				/* temporary variable used inside loops */

	/* checking for the first call of this function */
        if 	(SRF_IS_FIRSTCALL()) 
	{
		/* connecting to Oracle */
		/* dbh = oraconnect(login); */

		/* now it is time to perform a query */
		sth = oraquery(query);
		
		/* Let's get started and do some PostgreSQL related stuff */
		MemoryContext		oldcontext;

		/* create a function context for cross-call persistence */
                funcctx = SRF_FIRSTCALL_INIT();

                /* switch to memory context appropriate for multiple
		   function calls */
                oldcontext = MemoryContextSwitchTo(funcctx->multi_call_memory_ctx);

		/* setting the counter to 0 */
		/* funcctx->max_calls = 10; */

		/* generate tuple description */
		elog(NOTICE, "Found %d columns", nc);
		tupdesc = CreateTemplateTupleDesc(nc, false);

		/* now it is time to build the data structure */
		/* this is the key component of this software */
		/* TupleDescInitEntry(tupdesc, attnum, attname, sql_atttypid, -1, 0, false); */
		for	(tmp = 0; tmp < nc; tmp++)
		{
			sprintf(pgcolname, "%d", tmp);
			TupleDescInitEntry(tupdesc, tmp + 1, pgcolname, 25, -1, 0, false);
		}

		slot = TupleDescGetSlot(tupdesc);
		funcctx->slot = slot;
		attinmeta = TupleDescGetAttInMetadata(tupdesc);
		funcctx->attinmeta = attinmeta;
	}
	
	/* has to be done for every call */
	funcctx = SRF_PERCALL_SETUP();
	call_cntr = funcctx->call_cntr;
	slot = funcctx->slot;
	attinmeta = funcctx->attinmeta;

	/* now we will fetch some data */
	if	(SQLO_SUCCESS == (status = (sqlo_fetch(sth, 1))))
	{
		char 		**values;
		HeapTuple 	tuple;
		Datum 		result;

   	 	/* get one record */
    		v = sqlo_values(sth, NULL, 1);

    		/* get the length of the data items */
    		vl = sqlo_value_lens(sth, NULL);

    		/* print the column values */
		values = (char **) palloc(nc * sizeof(char));
    		for 	(i = 0; i < nc; ++i)
		{
			int len;
			len = (vl[i] + 1) > COLLEN ? COLLEN : vl[i] + 1;
			values[i] = (char *) palloc(len * sizeof(char));
			snprintf(values[i], len, "%s", v[i]);
		}

		tuple = BuildTupleFromCStrings(attinmeta, values);
		result = TupleGetDatum(slot, tuple);
		
		SRF_RETURN_NEXT(funcctx, result);
	}
        else
	{
		/* sqlo_finish(dbh); */

		/* nothing left to return */
		SRF_RETURN_DONE(funcctx);
	}	
}



