-- select data. a persistent connection must be open
DROP FUNCTION dblink_ora(text);
CREATE OR REPLACE FUNCTION dblink_ora(text) RETURNS SETOF RECORD
AS '/usr/src/postgresql-7.3.3/contrib/dblink_ora/liborapg.so' LANGUAGE 'C' IMMUTABLE STRICT;

-- opening a persistent connection to the database
DROP FUNCTION dblink_oraconnect(text);
CREATE OR REPLACE FUNCTION dblink_oraconnect(text) RETURNS text
AS '/usr/src/postgresql-7.3.3/contrib/dblink_ora/liborapg.so' LANGUAGE 'C' IMMUTABLE STRICT;

-- disconnect
DROP FUNCTION dblink_oradisconnect();
CREATE OR REPLACE FUNCTION dblink_oradisconnect() RETURNS text
AS '/usr/src/postgresql-7.3.3/contrib/dblink_ora/liborapg.so' LANGUAGE 'C' IMMUTABLE STRICT;

-- opening a persistent connection to the database
DROP FUNCTION dblink_oradisconnect();
CREATE OR REPLACE FUNCTION dblink_oradisconnect() RETURNS text
AS '/usr/src/postgresql-7.3.3/contrib/dblink_ora/liborapg.so' LANGUAGE 'C' IMMUTABLE STRICT;

-- exexute a command
DROP FUNCTION dblink_oraexec(text);
CREATE OR REPLACE FUNCTION dblink_oraexec(text) RETURNS int4
AS '/usr/src/postgresql-7.3.3/contrib/dblink_ora/liborapg.so' LANGUAGE 'C' IMMUTABLE STRICT;

---------------------------------------------------------------------------------------------
-- SELECT * FROM dblink_ora('scott/tiger@dbname', 
--	'SELECT a.deptno, a.dname, a.loc FROM dept a') AS (DEPTNO text, DNAME text, LOC text);

SELECT dblink_oraconnect('scott/tiger@dbname');
SELECT * FROM dblink_ora('SELECT ename, sal FROM emp') AS (ename text, sal text);
SELECT 'BEGIN', dblink_oraexec('BEGIN');
SELECT 'UPDATE emp SET sal = sal - 1', dblink_oraexec('UPDATE emp SET sal = sal - 1');
SELECT 'ROLLBACK', dblink_oraexec('ROLLBACK');
SELECT * FROM dblink_ora('SELECT ename, sal FROM emp') AS (ename text, sal text);
SELECT 'BEGIN', dblink_oraexec('BEGIN');
SELECT 'UPDATE emp SET sal = sal + 1', dblink_oraexec('UPDATE emp SET sal = sal + 1');
SELECT * FROM dblink_ora('SELECT ename, sal FROM emp') AS (ename text, sal text);
SELECT 'UPDATE emp SET sal = sal - 1', dblink_oraexec('UPDATE emp SET sal = sal - 1');
SELECT 'COMMIT', dblink_oraexec('COMMIT');
SELECT dblink_oradisconnect();

