#include "postgres.h"
#include "fmgr.h"
#include "utils/builtins.h"

#include <locale.h>
#include <string.h>

Datum getlocale(PG_FUNCTION_ARGS);

PG_FUNCTION_INFO_V1(getlocale);

Datum
getlocale(PG_FUNCTION_ARGS)
{
    char  category_string[16];
    char* res;
    text* category_text;
    int32 category_text_size;
    text* res_text;
    int32 res_text_size;
    
    memset(category_string,0,16);
    category_text = PG_GETARG_TEXT_P(0);
    category_text_size = VARSIZE(category_text)-VARHDRSZ;
    if (category_text_size >= 16) category_text_size = 15;
    strncpy(category_string, (char *) VARDATA(category_text), category_text_size);

    if      (!strcmp(category_string,"LC_COLLATE"))   res = setlocale(LC_COLLATE, NULL);
    else if (!strcmp(category_string,"LC_CTYPE"))     res = setlocale(LC_CTYPE, NULL);
    else if (!strcmp(category_string,"LC_MESSAGES"))  res = setlocale(LC_MESSAGES, NULL);
    else if (!strcmp(category_string,"LC_MONETARY"))  res = setlocale(LC_MONETARY, NULL);
    else if (!strcmp(category_string,"LC_NUMERIC"))   res = setlocale(LC_NUMERIC, NULL);
    else if (!strcmp(category_string,"LC_TIME"))      res = setlocale(LC_TIME, NULL);
    else                                              res = setlocale(LC_ALL, NULL);

    res_text_size = VARHDRSZ + strlen(res);
    res_text = (text *) palloc(res_text_size);

    strcpy(VARDATA(res_text), res);
    VARATT_SIZEP(res_text) = res_text_size;

    PG_RETURN_TEXT_P(res_text);

}

