/*-------------------------------------------------------------------------
 *
 * pg_partition.h
 *	  definition of the system "partition" relation (pg_partition)
 *	  along with the relation's initial contents.
 *
 *
 * Portions Copyright (c) 1996-2008, PostgreSQL Global Development Group
 *
 * $PostgreSQL: pgsql/src/include/catalog/pg_partition.h,v 1.0 2009/02/03 03:57:34 tgl Exp $
 *
 * NOTES
 *	  the genbki.sh script reads this file and generates .bki
 *	  information from the DATA() statements.
 *
 *-------------------------------------------------------------------------
 */
#ifndef PG_PARTITION_H
#define PG_PARTITION_H

#include "catalog/genbki.h"

/* ----------------
 *		pg_partition definition.  cpp turns this into
 *		typedef struct FormData_pg_partitions
 * ----------------
 */
#define PartitionRelationId 2336

CATALOG(pg_partition,2336) 
{
    Oid         partrelid;      /* partition table Oid */
    Oid         parentrelid;    /* Parent table Oid */
    int2        parttype;       /* Type of partition, list, hash, range */
    Oid         partkey;        /* partition key Oid */
    Oid         keytype;        /* type of partition key */
    int2        keyorder;       /* order of the key in multi-key partitions */
    bytea       minval;
    bytea       maxval;             /* min and max for range partition */
    bytea       listval;
    int2        hashval;            /* hash value */
} FormData_pg_partition;

/* ----------------
 *      Form_pg_partitions corresponds to a pointer to a tuple with
 *      the format of pg_partitions relation.
 * ----------------
 */
typedef FormData_pg_partition *Form_pg_partition;

/* ----------------
 *      compiler constants for pg_partitions
 * ----------------
 */
#define Natts_pg_partition              10
#define Anum_pg_partition_partrelid     1
#define Anum_pg_partition_parentrelid   2
#define Anum_pg_partition_parttype      3
#define Anum_pg_partition_partkey       4
#define Anum_pg_partition_minval        7
#define Anum_pg_partition_maxval        8
#define Anum_pg_partition_listval       9
#define Anum_pg_partition_hashval       10
#define Anum_pg_partition_keytype       5
#define Anum_pg_partition_keyorder      6

#endif   /* PG_PARTITIONS_H */
