/*-------------------------------------------------------------------------
 *
 * walsender.h
 *	  Exports from postmaster/walsender.c.
 *
 * Portions Copyright (c) 1996-2008, PostgreSQL Global Development Group
 *
 * $PostgreSQL: pgsql/src/include/postmaster/walsender.h,v 1.2 2008/01/01 19:45:58 momjian Exp $
 *
 *-------------------------------------------------------------------------
 */
#ifndef _WALSENDER_H
#define _WALSENDER_H

#include "access/xlog.h"
#include "libpq/libpq.h"

/* global state */
extern bool	am_walsender;

/* main */
extern int	WalSenderMain(void);
extern void DeclareWalSender(Port *port, char *remote_ps_data);

/* communication with the other process */
extern Size WalSenderShmemSize(void);
extern void WalSenderShmemInit(void);
extern bool WalSenderRequestAdd(pid_t pid, XLogRecPtr requestLSN);
extern void WalSenderRequestRemove(pid_t pid);

/* common routines */
extern pid_t	GetWalSenderPid(void);

#endif   /* _WALSENDER_H */
