#!/bin/bash

( # do not exit from parent
  set -eu

  timeout=10
  echo "wait master $timeout sec ..."
  for ((i = 0; i < 10; i++)); do
    if psql -q -h master -c 'select 1' > /dev/null; then
      break
    else
      echo -n .
      sleep 1
    fi
  done
  echo "ok"

  echo "init standby ..."

  set -x

  # see postgres docker-entrypoint.sh
  pg_ctl -D "$PGDATA" -m fast -w stop

  rm -r "$PGDATA"/*

  pg_basebackup -v -D "$PGDATA" -c fast -h master

  tee "$PGDATA"/recovery.conf <<EOF
restore_command = 'cp /var/lib/postgresql/wals/%f %p'
archive_cleanup_command = 'pg_archivecleanup /var/lib/postgresql/wals/ %r'
standby_mode = on
EOF

  # see postgres docker-entrypoint.sh
  pg_ctl -D "$PGDATA" -o "-c listen_addresses='localhost'" start
  # wait for startup (create pid file)
  sleep 5

  set +x

  echo "ok"
)
