#include <sql.h> 
#include <sqlext.h> 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char *argv[]) {
  SQLHENV     hEnv = NULL; 
  SQLHDBC     hDbc = NULL; 
  SQLHSTMT    hStmt = NULL; 
  RETCODE     retcode, retcode2;
  int         i;
  SQLPOINTER  field;
  SQLLEN      dataAtExec = SQL_DATA_AT_EXEC;
  SQLCHAR     state[6];
  SQLINTEGER  nativeError;
  SQLCHAR     messageText[4097];
  SQLSMALLINT textLength;

  static char description[64*1024*1024 + 1];
  memset(description, 'A', 64*1024*1024);
  description[64*1024*1024] = '\0';
  
  if(argc != 4) {
    fprintf(stderr, "Incorrect invocation. Use '%s DB USER PASS'\n", argv[0]);
    exit(2);
  }
  
  if(SQLAllocHandle(SQL_HANDLE_ENV, SQL_NULL_HANDLE, &hEnv)) {
    fprintf(stderr, "Unable to alloc environment handle\n");
    exit(1);
  }

  retcode = SQLSetEnvAttr(hEnv, SQL_ATTR_ODBC_VERSION, (SQLPOINTER)SQL_OV_ODBC3, 0);
  if(retcode != SQL_SUCCESS && retcode != SQL_SUCCESS_WITH_INFO) {
    fprintf(stderr, "error when setting SQL_ATTR_ODBC_VERSION\n");
    SQLFreeHandle(SQL_HANDLE_ENV, hEnv);
    exit(1);
  }

  retcode = SQLAllocHandle(SQL_HANDLE_DBC, hEnv, &hDbc);
  if(retcode != SQL_SUCCESS && retcode != SQL_SUCCESS_WITH_INFO) {
    fprintf(stderr, "unable to allocate connection handle\n");
    SQLFreeHandle(SQL_HANDLE_ENV, hEnv);
    exit(1);
  }

  retcode = SQLConnect(hDbc, (SQLCHAR *)argv[1], SQL_NTS, (SQLCHAR *)argv[2], SQL_NTS, (SQLCHAR *)argv[3], SQL_NTS);
  if(retcode != SQL_SUCCESS && retcode != SQL_SUCCESS_WITH_INFO) {
    fprintf(stderr, "Connection to the datasource failed(dsn = %s, user = %s, passwd = %s)\n", argv[1], argv[2], argv[3]);
    SQLFreeHandle(SQL_HANDLE_DBC, hDbc);
    SQLFreeHandle(SQL_HANDLE_ENV, hEnv);
    exit(3);
  }

  retcode = SQLAllocHandle(SQL_HANDLE_STMT, hDbc, &hStmt);
  if(retcode != SQL_SUCCESS && retcode != SQL_SUCCESS_WITH_INFO) {
    fprintf(stderr, "failed to allocate statement handle\n");
    SQLDisconnect(hDbc);
    SQLFreeHandle(SQL_HANDLE_DBC, hDbc);
    SQLFreeHandle(SQL_HANDLE_ENV, hEnv);
    exit(1);
  }

  retcode = SQLPrepare(hStmt, (SQLCHAR *)"INSERT INTO leak_test(id, description) VALUES(?, ?)", SQL_NTS);
  if(retcode != SQL_SUCCESS && retcode != SQL_SUCCESS_WITH_INFO) {
    fprintf(stderr, "failed to prepare insert statement\n");
    SQLFreeHandle(SQL_HANDLE_STMT, hStmt);
    SQLDisconnect(hDbc);
    SQLFreeHandle(SQL_HANDLE_DBC,  hDbc);
    SQLFreeHandle(SQL_HANDLE_ENV,  hEnv);
    exit(1);
  }

  retcode = SQLBindParameter(hStmt, 1, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_NUMERIC, 19, 0, (SQLPOINTER)1, 0, &dataAtExec);
  if (retcode != SQL_SUCCESS && retcode != SQL_SUCCESS_WITH_INFO) {
    fprintf(stderr, "failed to bind id parameter");
    SQLFreeHandle(SQL_HANDLE_STMT, hStmt);
    SQLDisconnect(hDbc);
    SQLFreeHandle(SQL_HANDLE_DBC,  hDbc);
    SQLFreeHandle(SQL_HANDLE_ENV,  hEnv);
    exit(1);
  }
  
  retcode = SQLBindParameter(hStmt, 2, SQL_PARAM_INPUT, SQL_C_CHAR, SQL_CHAR, 64*1024*1024, 0, (SQLPOINTER)2, 0, &dataAtExec);
  if (retcode != SQL_SUCCESS && retcode != SQL_SUCCESS_WITH_INFO) {
    fprintf(stderr, "failed to bind description parameter");
    SQLFreeHandle(SQL_HANDLE_STMT, hStmt);
    SQLDisconnect(hDbc);
    SQLFreeHandle(SQL_HANDLE_DBC,  hDbc);
    SQLFreeHandle(SQL_HANDLE_ENV,  hEnv);
    exit(1);
  }

  printf("Inserting 100 records. Press ENTER to start\n");
  while(getchar() != '\n');

  for (i=0; i<100; i++) {
    retcode = SQLExecute(hStmt);
    while(retcode == SQL_NEED_DATA) {
      retcode = SQLParamData(hStmt, &field);
      if (retcode == SQL_NEED_DATA) {
        if(field == (SQLPOINTER)1) {
          retcode2 = SQLPutData(hStmt, "123", SQL_NTS);
        } else if (field == (SQLPOINTER)2) {
          retcode2 = SQLPutData(hStmt, description, SQL_NTS);
        }
        if(retcode2 != SQL_SUCCESS && retcode2 != SQL_SUCCESS_WITH_INFO) {
          fprintf(stderr, "SQLPutData failed for field %ld, record %d\n", (long)field, i);
        }
      }
    }
    switch (retcode) {
    case SQL_SUCCESS:
    case SQL_SUCCESS_WITH_INFO:
    case SQL_NO_DATA:
      break;
    case SQL_ERROR:
      retcode2 = SQLGetDiagRec(SQL_HANDLE_STMT, hStmt, 1, state, &nativeError, messageText, 4097, &textLength);
      if (retcode2 == SQL_SUCCESS || retcode2 == SQL_SUCCESS_WITH_INFO) {
        state[5] = '\0';
        fprintf(stderr, "Error inserting record %d: %s - %d - %s\n", i, state, nativeError, messageText);
      }
      break;
    default:
      fprintf(stderr, "Failed to insert record %d (%d)\n", i, retcode);
    }
  }

  printf("Finish inserting 100 records. Press ENTER to continue freeing the statement and disconnectiong from database");
  while(getchar() != '\n');

  retcode = SQLFreeHandle(SQL_HANDLE_STMT, hStmt);
  if(retcode != SQL_SUCCESS && retcode != SQL_SUCCESS_WITH_INFO) {
    fprintf(stderr, "failed to free statement handle\n");
  }

  retcode = SQLDisconnect(hDbc);
  if(retcode != SQL_SUCCESS && retcode != SQL_SUCCESS_WITH_INFO) {
    fprintf(stderr, "failed to disconnect from the database\n");
  }
  
  retcode = SQLFreeHandle(SQL_HANDLE_DBC, hDbc);
  if(retcode != SQL_SUCCESS && retcode != SQL_SUCCESS_WITH_INFO) {
    fprintf(stderr, "failed to free connection handle\n");
  }

  retcode = SQLFreeHandle(SQL_HANDLE_ENV, hEnv);
  if(retcode != SQL_SUCCESS && retcode != SQL_SUCCESS_WITH_INFO) {
    fprintf(stderr, "failed to free environment handle\n");
  }

  printf("called disconnect and free handle on all handles. Press ENTER to end the program\n");
  while(getchar() != '\n');
  
  return 0;
}
