/* -------------------------------------------------------------------------
 *
 * test_dsa.c
 *		Simple exercises for dsa.c.
 *
 * Copyright (C) 2016, PostgreSQL Global Development Group
 *
 * IDENTIFICATION
 *		src/test/modules/test_dsa/test_dsa.c
 *
 * -------------------------------------------------------------------------
 */

#include "postgres.h"

#include "fmgr.h"
#include "funcapi.h"
#include "miscadmin.h"
#include "postmaster/bgworker.h"
#include "storage/latch.h"
#include "storage/proc.h"
#include "utils/builtins.h"
#include "utils/dsa.h"
#include "utils/resowner.h"
#include "utils/timestamp.h"
#include "storage/ipc.h"
#include "storage/shmem.h"

#include <stdlib.h>
#include <unistd.h>

typedef struct
{
	/* Message/Content of node in a LinkedList. */
	dsa_pointer dp;
	/* Pointer to next Message */
	struct shared_linked_list *next;
} shared_linked_list;

/* Shared Memory that holds dsa area and its handle... */
typedef struct
{
	/* Dynamic Shared Memory Area. */
	dsa_area *shared_area;
	/* Used to attach to Shared Memory Area. */
	dsa_handle shared_area_handle;
	/* Relative pointer to test data */
	dsa_pointer shared_data_ptr;
  /* Data structure to hold the data to be shared across processes */
  shared_linked_list *head;
} shared_data;


PG_MODULE_MAGIC;
PG_FUNCTION_INFO_V1(test_dsa_data_access);
void 	_PG_init(void);
/* Declaration of shared memory hook */
void BufferShmemHook(void);
/* structure declaration */
static shmem_startup_hook_type PreviousShmemHook = NULL;

shared_data *shmemData = NULL;

static int
my_tranche_id(void)
{
	static int tranche_id = 0;

	if (tranche_id == 0)
		tranche_id = LWLockNewTrancheId();

	return tranche_id;
}

/* Allocations in shared memory */
void BufferShmemHook(){
	/* Set up the shared memory area. */
	dsa_area *area;
	dsa_pointer data_ptr;
  char *mem;

	area = dsa_create(my_tranche_id());
  data_ptr = dsa_allocate(area, 42);
  mem = (char *) dsa_get_address(area, data_ptr);
  if (mem != NULL)
  {
      snprintf(mem, 42, "Hello world");
  }

  bool found;
	shmemData = ShmemInitStruct("Mahi_Shared_Data",
						   sizeof(shared_data),
						   &found);
	shmemData->shared_area = area;
	shmemData->shared_area_handle = dsa_get_handle(area);
	shmemData->shared_data_ptr = data_ptr;
  shmemData->head = NULL;
}

void
_PG_init(void)
{
	// Requesting shared memory and we have a control of that memory chunk..
	RequestAddinShmemSpace(100000000);
  PreviousShmemHook = shmem_startup_hook;
  shmem_startup_hook = BufferShmemHook;
}

Datum
test_dsa_data_access(PG_FUNCTION_ARGS)
{
		int i;
		dsa_pointer dp;
		char *mem,*req;
		shared_linked_list *list = NULL;

		/* Trying to read the data from dsa that was allocated in shared_memory_hook */
		mem = (char *) dsa_get_address(shmemData->shared_area, shmemData->shared_data_ptr);
		if (mem != NULL)
		{
		 elog(LOG, "Data read is ==> %s", mem);
		}

		/* Linked List Creation */
    list = (shared_linked_list *)ShmemAlloc(sizeof(shared_linked_list));
    shmemData->head = list;

		/* Linked List Allocation... Putting 10 LinkedList Nodes into Shared Memory */
    dp = dsa_allocate(shmemData->shared_area,30);
    list->dp=dp;
		list->next=NULL;
		req = (char *)dsa_get_address(shmemData->shared_area,list->dp);
		if(req != NULL)
			snprintf(req, 42, "Hello world0");

		for(i=1;i<10;i++)
		{
			shared_linked_list *new_node=(shared_linked_list*)ShmemAlloc(sizeof(shared_linked_list));
			list->next=new_node;
			list=list->next;

			dp=dsa_allocate(shmemData->shared_area,sizeof(shared_linked_list));
			list->dp=dp;
			list->next=NULL;
			req=(char *)dsa_get_address(shmemData->shared_area,list->dp );
			if(req != NULL)
				snprintf(req, 16, "Hello world%d",i);
		}

		/*
		* Creating Background Worker...
		* BackgroundWorker reads the 10 entries that were inserted here
		* Will add another 10
		* Those data will be read again by this process
		*/
		BackgroundWorkerHandle **handles;
		handles = palloc(sizeof(BackgroundWorkerHandle *));
		BackgroundWorker bgw;
		snprintf(bgw.bgw_name, sizeof(bgw.bgw_name), "worker1");
		bgw.bgw_flags = BGWORKER_SHMEM_ACCESS;
		bgw.bgw_start_time = BgWorkerStart_PostmasterStart;
		bgw.bgw_restart_time = BGW_NEVER_RESTART;
		snprintf(bgw.bgw_library_name, sizeof(bgw.bgw_library_name),
		"test_dsa");
		snprintf(bgw.bgw_function_name, sizeof(bgw.bgw_function_name),
		"test_dsa_worker_main");
		memcpy(bgw.bgw_extra, &shmemData, sizeof(shmemData));
		bgw.bgw_notify_pid = MyProcPid;
		if (!RegisterDynamicBackgroundWorker(&bgw, &handles[0]))
			elog(ERROR, "Can't start worker");

		WaitForBackgroundWorkerShutdown(handles[0]);

		/* Reading Data that was inserted by this process as well as by Backgroundworker */
		list=shmemData->head;
		while(list!=NULL)
		{
			mem = (char *) dsa_get_address(shmemData->shared_area, list->dp);
			if (mem != NULL)
			{
				elog(LOG, "LinkedList Node Data read is ==> %s", mem);
			}
			list=list->next;
		}
		return (Datum) 0;
}

/* Backgroundworker Main function */
Datum test_dsa_worker_main(Datum arg);

Datum
test_dsa_worker_main(Datum arg)
{
		int i;
		char *mem;
		char *req;
		dsa_pointer dp;
		shared_linked_list *list;

		/* Reading the data from dsa that is inserted by UDF function */
		list = shmemData->head;
		while(list->next!=NULL)
		{
			mem = (char *) dsa_get_address(shmemData->shared_area, list->dp);
			if (mem != NULL)
			{
				elog(LOG, "BackgroundWorker Shared LinkedList Data read is ==> %s", mem);
			}
			list=list->next;
		}

		/* Inserting 10 more... UDF will going to read them later...*/
		for(i=10;i<20;i++)
		{
			shared_linked_list *new_node=(shared_linked_list*)ShmemAlloc(sizeof(shared_linked_list));
			list->next=new_node;
			list=list->next;
			list->next=NULL;

			dp=dsa_allocate(shmemData->shared_area,sizeof(shared_linked_list));
			list->dp=dp;
			req=(char *)dsa_get_address(shmemData->shared_area,list->dp );
			if(req != NULL)
				snprintf(req, 16, "Hello world%d",i);
		}
		return (Datum) 0;
}
