#ifndef VARCHAR_H
#define VARCHAR_H

#include <stddef.h>

#undef WORDS_BIGENDIAN

typedef unsigned char uint8;
typedef unsigned long uint32;
typedef long int32;
typedef unsigned int Oid;
typedef char bool;

#define true ((bool) 1)
#define TrapMacro(condition, errorType) (true)

struct varlena
{
    char        vl_len_[4];     /* Do not touch this field directly! */
    char        vl_dat[1];
};
typedef struct varlena BpChar;  /* blank-padded char, ie SQL char(n) */

typedef union
{
    struct                      /* Normal varlena (4-byte length) */
    {
        uint32      va_header;
        char        va_data[1];
    }           va_4byte;
    struct                      /* Compressed-in-line format */
    {
        uint32      va_header;
        uint32      va_rawsize; /* Original data size (excludes header) */
        char        va_data[1]; /* Compressed data */
    }           va_compressed;
} varattrib_4b;

typedef struct
{
    uint8       va_header;
    char        va_data[1];     /* Data begins here */
} varattrib_1b;

/* inline portion of a short varlena pointing to an external resource */
typedef struct
{
    uint8       va_header;      /* Always 0x80 or 0x01 */
    uint8       va_tag;         /* Type of datum */
    char        va_data[1];     /* Data (of the type indicated by va_tag) */
} varattrib_1b_e;

typedef struct varatt_indirect
{
    struct varlena *pointer;    /* Pointer to in-memory varlena */
}   varatt_indirect;

typedef struct varatt_external
{
    int32       va_rawsize;     /* Original data size (includes header) */
    int32       va_extsize;     /* External saved size (doesn't) */
    Oid         va_valueid;     /* Unique ID of value within TOAST table */
    Oid         va_toastrelid;  /* RelID of TOAST table containing it */
}   varatt_external;


#ifdef WORDS_BIGENDIAN

#define VARATT_IS_4B(PTR) \
        ((((varattrib_1b *) (PTR))->va_header & 0x80) == 0x00)
#define VARATT_IS_4B_U(PTR) \
        ((((varattrib_1b *) (PTR))->va_header & 0xC0) == 0x00)
#define VARATT_IS_4B_C(PTR) \
        ((((varattrib_1b *) (PTR))->va_header & 0xC0) == 0x40)
#define VARATT_IS_1B(PTR) \
        ((((varattrib_1b *) (PTR))->va_header & 0x80) == 0x80)
#define VARATT_IS_1B_E(PTR) \
        ((((varattrib_1b *) (PTR))->va_header) == 0x80)
#define VARATT_NOT_PAD_BYTE(PTR) \
        (*((uint8 *) (PTR)) != 0)

/* VARSIZE_4B() should only be used on known-aligned data */
#define VARSIZE_4B(PTR) \
        (((varattrib_4b *) (PTR))->va_4byte.va_header & 0x3FFFFFFF)
#define VARSIZE_1B(PTR) \
        (((varattrib_1b *) (PTR))->va_header & 0x7F)
#define VARTAG_1B_E(PTR) \
        (((varattrib_1b_e *) (PTR))->va_tag)
#define SET_VARSIZE_4B(PTR,len) \
        (((varattrib_4b *) (PTR))->va_4byte.va_header = (len) & 0x3FFFFFFF)
#define SET_VARSIZE_4B_C(PTR,len) \
        (((varattrib_4b *) (PTR))->va_4byte.va_header = ((len) & 0x3FFFFFFF) | 0x40000000)
#define SET_VARSIZE_1B(PTR,len) \
        (((varattrib_1b *) (PTR))->va_header = (len) | 0x80)
#define SET_VARTAG_1B_E(PTR,tag) \
        (((varattrib_1b_e *) (PTR))->va_header = 0x80, \
         ((varattrib_1b_e *) (PTR))->va_tag = (tag))
#else                                                   /* !WORDS_BIGENDIAN */

#define VARATT_IS_4B(PTR) \
        ((((varattrib_1b *) (PTR))->va_header & 0x01) == 0x00)
#define VARATT_IS_4B_U(PTR) \
        ((((varattrib_1b *) (PTR))->va_header & 0x03) == 0x00)
#define VARATT_IS_4B_C(PTR) \
        ((((varattrib_1b *) (PTR))->va_header & 0x03) == 0x02)
#define VARATT_IS_1B(PTR) \
        ((((varattrib_1b *) (PTR))->va_header & 0x01) == 0x01)
#define VARATT_IS_1B_E(PTR) \
        ((((varattrib_1b *) (PTR))->va_header) == 0x01)
#define VARATT_NOT_PAD_BYTE(PTR) \
        (*((uint8 *) (PTR)) != 0)
/* VARSIZE_4B() should only be used on known-aligned data */
#define VARSIZE_4B(PTR) \
        ((((varattrib_4b *) (PTR))->va_4byte.va_header >> 2) & 0x3FFFFFFF)
#define VARSIZE_1B(PTR) \
        ((((varattrib_1b *) (PTR))->va_header >> 1) & 0x7F)
#define VARTAG_1B_E(PTR) \
        (((varattrib_1b_e *) (PTR))->va_tag)

#define SET_VARSIZE_4B(PTR,len) \
        (((varattrib_4b *) (PTR))->va_4byte.va_header = (((uint32) (len)) << 2))
#define SET_VARSIZE_4B_C(PTR,len) \
        (((varattrib_4b *) (PTR))->va_4byte.va_header = (((uint32) (len)) << 2) | 0x02)
#define SET_VARSIZE_1B(PTR,len) \
        (((varattrib_1b *) (PTR))->va_header = (((uint8) (len)) << 1) | 0x01)
#define SET_VARTAG_1B_E(PTR,tag) \
        (((varattrib_1b_e *) (PTR))->va_header = 0x01, \
         ((varattrib_1b_e *) (PTR))->va_tag = (tag))
#endif   /* WORDS_BIGENDIAN */

#define VARSIZE_ANY_EXHDR(PTR) \
    (VARATT_IS_1B_E(PTR) ? VARSIZE_EXTERNAL(PTR)-VARHDRSZ_EXTERNAL : \
     (VARATT_IS_1B(PTR) ? VARSIZE_1B(PTR)-VARHDRSZ_SHORT : \
      VARSIZE_4B(PTR)-VARHDRSZ))

#define VARDATA_ANY(PTR) \
     (VARATT_IS_1B(PTR) ? VARDATA_1B(PTR) : VARDATA_4B(PTR))

#define VARHDRSZ        ((int32) sizeof(int32))
#define VARHDRSZ_SHORT  offsetof(varattrib_1b, va_data)

#define VARHDRSZ_EXTERNAL       offsetof(varattrib_1b_e, va_data)
#define VARDATA_4B(PTR)     (((varattrib_4b *) (PTR))->va_4byte.va_data)
#define VARDATA_4B_C(PTR)   (((varattrib_4b *) (PTR))->va_compressed.va_data)
#define VARDATA_1B(PTR)     (((varattrib_1b *) (PTR))->va_data)
#define VARDATA_1B_E(PTR)   (((varattrib_1b_e *) (PTR))->va_data)
#define VARSIZE_EXTERNAL(PTR)               (VARHDRSZ_EXTERNAL + VARTAG_SIZE(VARTAG_EXTERNAL(PTR)))
#define VARTAG_EXTERNAL(PTR)				VARTAG_1B_E(PTR)
typedef enum vartag_external
{
    VARTAG_INDIRECT = 1,
    VARTAG_ONDISK = 18
} vartag_external;

#define VARTAG_SIZE(tag) \
    ((tag) == VARTAG_INDIRECT ? sizeof(varatt_indirect) :       \
     (tag) == VARTAG_ONDISK ? sizeof(varatt_external) : \
     TrapMacro(true, "unknown vartag"))

int bcTruelen1(BpChar *arg);
int bcTruelen2(BpChar *arg);
int bcTruelen3(BpChar *arg);
int bcTruelen4(BpChar *arg);
int bcNop(BpChar *arg);

#endif
