#include <stdio.h>

#include <windows.h>
  
#include <sqlext.h>

#define NAME_LEN 50
  
void show_error()
{
	wprintf(L"error\n");
}
  

int main()
{
	SQLWCHAR DSN[] = L"TestODBC";
	SQLWCHAR user[] = L"postgres";
	SQLWCHAR password[] = L"postgres";

	SQLHENV henv = SQL_NULL_HENV;
	SQLHDBC hdbc = SQL_NULL_HDBC;
	SQLHSTMT hstmt = SQL_NULL_HSTMT;
	SQLRETURN retcode = SQL_SUCCESS;
	SQLWCHAR szName[NAME_LEN];
	SQLLEN cbName = 0;
  
	// Allocate environment handle
	retcode = SQLAllocHandle(SQL_HANDLE_ENV, SQL_NULL_HANDLE, &henv);
  
	// Set the ODBC version environment attribute
	if (retcode == SQL_SUCCESS || retcode == SQL_SUCCESS_WITH_INFO)
	{
		retcode = SQLSetEnvAttr(henv, SQL_ATTR_ODBC_VERSION, (SQLPOINTER*)SQL_OV_ODBC3, 0); 
  
		// Allocate connection handle
		if (retcode == SQL_SUCCESS || retcode == SQL_SUCCESS_WITH_INFO)
		{
			retcode = SQLAllocHandle(SQL_HANDLE_DBC, henv, &hdbc);
  
			// Set login timeout to 5 seconds
			if (retcode == SQL_SUCCESS || retcode == SQL_SUCCESS_WITH_INFO)
			{
				SQLSetConnectAttr(hdbc, SQL_LOGIN_TIMEOUT, (SQLPOINTER)5, 0);
  
				// Connect to data source
				retcode = SQLConnect(hdbc, DSN, SQL_NTS, user, SQL_NTS, password, SQL_NTS);
  
				if (retcode == SQL_SUCCESS || retcode == SQL_SUCCESS_WITH_INFO)
				{
					// Start a transaction
					retcode = SQLSetConnectAttr(hdbc, SQL_ATTR_AUTOCOMMIT, SQL_AUTOCOMMIT_OFF, SQL_IS_UINTEGER);

					// Allocate statement handle
					retcode = SQLAllocHandle(SQL_HANDLE_STMT, hdbc, &hstmt); 
  
					if (retcode == SQL_SUCCESS || retcode == SQL_SUCCESS_WITH_INFO)
					{
						retcode = SQLSetStmtAttr(hstmt, SQL_ATTR_CURSOR_TYPE, (SQLPOINTER)SQL_CURSOR_STATIC, SQL_IS_UINTEGER);

						if (retcode == SQL_SUCCESS || retcode == SQL_SUCCESS_WITH_INFO)
						{
							// Reported problem if "Use Declare/Fetch" is active in the ODBC-DSN:

							// When executing this statement, SQLExtendedFetch(hstmt, SQL_FETCH_FIRST, ...)
							// Crash when using debugger
							// Without debugger: No valid data is returned
//							retcode = SQLExecDirect(hstmt, L"SELECT col FROM tab WHERE col = '1'", SQL_NTS);

							// When executing this statement, SQLExtendedFetch(hstmt, SQL_FETCH_FIRST, ...) will fetch the second row!
							// With debugger: Crash when calling SQLExtendedFetch(hstmt, SQL_FETCH_NEXT, ...) on the last row.
							// Without debugger: The content of the last row will be returned twice.
							retcode = SQLExecDirect(hstmt, L"SELECT col FROM tab ORDER BY col", SQL_NTS);

							if (retcode == SQL_SUCCESS || retcode == SQL_SUCCESS_WITH_INFO)
							{
								retcode = SQLBindCol(hstmt, 1, SQL_C_WCHAR, &szName, NAME_LEN * sizeof(SQLWCHAR), &cbName);

								SQLUINTEGER fetchedrows = 0;
								SQLUSMALLINT rowstatus[100];

								// commit transaction
								retcode = SQLEndTran(SQL_HANDLE_DBC, hdbc, SQL_COMMIT);

								retcode = SQLSetConnectAttr(hdbc, SQL_ATTR_AUTOCOMMIT, (SQLPOINTER)SQL_AUTOCOMMIT_ON, SQL_IS_UINTEGER);

								retcode = SQLExtendedFetch(hstmt, SQL_FETCH_FIRST, 0, &fetchedrows, rowstatus);

								int i = 0;

								// Process data
								while (retcode == SQL_SUCCESS || retcode == SQL_SUCCESS_WITH_INFO)
								{
									if (retcode == SQL_ERROR || retcode == SQL_SUCCESS_WITH_INFO)
										show_error();
									if (retcode == SQL_SUCCESS || retcode == SQL_SUCCESS_WITH_INFO)
										wprintf(L"%d: %s\n", i + 1, szName);
									else
										break;
									i++;
									retcode = SQLExtendedFetch(hstmt, SQL_FETCH_NEXT, 0, &fetchedrows, rowstatus);
								}
							}
						}
  
						if (retcode == SQL_SUCCESS || retcode == SQL_SUCCESS_WITH_INFO)
						{
							SQLCancel(hstmt);
							SQLFreeHandle(SQL_HANDLE_STMT, hstmt);
						}
					}
  
					SQLDisconnect(hdbc);
				}
  
				SQLFreeHandle(SQL_HANDLE_DBC, hdbc);
			}
		}
		SQLFreeHandle(SQL_HANDLE_ENV, henv);
	}

	wprintf(L"Press ENTER");
	getwchar();
}
