CREATE EXTENSION pg_stat_statements;
CREATE TABLE time_bench (label text, time_mark timestamp);
CREATE TABLE blocks_bench (label text, blocks_mark bigint);
CREATE TABLE size_bench (label text, size bigint);

CREATE TABLE fts_test AS (SELECT id, fti FROM messages);
VACUUM ANALYZE fts_test;

INSERT INTO time_bench VALUES ('index_build_start', now());
CREATE INDEX fts_test_idx ON fts_test USING gin (fti);
INSERT INTO time_bench VALUES ('index_build_end', now());
INSERT INTO size_bench VALUES ('new', pg_relation_size('fts_test_idx'));

INSERT INTO time_bench VALUES ('search_new_start', now());
SELECT pg_stat_statements_reset();