#!/bin/sh

export PATH=$PATH:/home/korotkov/pgsql/bin

launch_pg()
{
    postgres -D /db/pgdata &
    PG_PID=$!
    pg_isready
    while [ $? -ne 0 ]; do
        sleep 1
        pg_isready
    done
}

kill_pg()
{
    kill -9 $PG_PID
    sleep 1
    killall -9 -u `whoami` postgres
    sleep 1
    rm /db/pgdata/postmaster.pid
}

if [ -z "$1" ]
then
    echo "Usage: bench.sh branch_name"
    exit 1
fi

cd postgres
git reset --hard
git pull
if [ $? -ne 0 ]; then
    echo "Error pull!"
    exit 1
fi
git checkout $1
if [ $? -ne 0 ]; then
    echo "Error switching branch!"
    exit 1
fi

./configure --enable-debug --with-pgport=5431 --prefix=/home/korotkov/pgsql
make clean
make install
if [ $? -ne 0 ]; then
    echo "Error make install!"
    exit 1
fi
cd contrib
make clean
make install
if [ $? -ne 0 ]; then
    echo "Error contrib make install!"
    exit 1
fi

rm -rf /db/pgdata/*
initdb -D /db/pgdata/
cp ~/tsearch_data/* ~/pgsql/share/tsearch_data
cp ~/postgresql.conf /db/pgdata
if [ $? -ne 0 ]; then
    echo "Error make initdb!"
    exit 1
fi

launch_pg

gzip -c -d ~/archives-9.1-main.dump.gz | ~/pgsql/bin/pg_restore -d postgres -Fc -O -x
psql postgres -f ~/bench_1.sql
kill_pg
RECOVERY_START=`date`
launch_pg
RECOVERY_END=`date`
psql postgres -c "INSERT INTO time_bench VALUES ('index_build_recovery_start', '$RECOVERY_START');"
psql postgres -c "INSERT INTO time_bench VALUES ('index_build_recovery_end', '$RECOVERY_END');"

psql postgres -f ~/bench_2.sql
psql postgres -f ~/bench_queries.sql
psql postgres -f ~/bench_3.sql
kill_pg
RECOVERY_START=`date`
launch_pg
RECOVERY_END=`date`
psql postgres -c "INSERT INTO time_bench VALUES ('index_update_recovery_start', '$RECOVERY_START');"
psql postgres -c "INSERT INTO time_bench VALUES ('index_update_recovery_end', '$RECOVERY_END');"

psql postgres -f ~/bench_4.sql
psql postgres -f ~/bench_queries.sql
psql postgres -f ~/bench_5.sql

psql postgres -f ~/report.sql > ~/report_$1.txt

kill $PG_PID
