#!/bin/sh

export PATH=$PATH:/home/korotkov/pgsql/bin

if [ -z "$1" ]
then
    echo "Usage: bench.sh branch_name"
    exit 1
fi

cd postgres
git checkout $1
if [ $? -ne 0 ]; then
    echo "Error switching branch!"
    exit 1
fi
git pull
if [ $? -ne 0 ]; then
    echo "Error pull branch!"
    exit 1
fi

./configure --enable-debug --with-pgport=5431 --prefix=/home/korotkov/pgsql
make clean
make install
if [ $? -ne 0 ]; then
    echo "Error make install!"
    exit 1
fi
cd contrib
make clean
make install
if [ $? -ne 0 ]; then
    echo "Error contrib make install!"
    exit 1
fi

rm -rf /db/pgdata/*
initdb -D /db/pgdata/
cp ~/tsearch_data/* ~/pgsql/share/tsearch_data
cp ~/postgresql.conf /db/pgdata
if [ $? -ne 0 ]; then
    echo "Error make initdb!"
    exit 1
fi

postgres -D /db/pgdata &

pg_isready
if [ $? -ne 0 ]; then
    sleep 1
    pg_isready
fi

gzip -c -d ~/archives-9.1-main.dump.gz | ~/pgsql/bin/pg_restore -d postgres -Fc -O -x
psql postgres -f ~/bench_begin.sql
psql postgres -f ~/bench_queries.sql
psql postgres -f ~/bench_middle.sql
psql postgres -f ~/bench_queries.sql
psql postgres -f ~/bench_end.sql

psql postgres -f ~/report.sql > ~/report_$1.txt

kill 0
