import jargs.gnu.*;
import java.lang.*;
import java.util.*;
import java.sql.*;

import benchmark.*;

public class Main
{
	public static void main(String[] args)
	{
		Main main = new Main(args);
	}

	public Main(String[] args)
	{
		this.parseCommandLine(args);

		/* start the benchmark */
		Benchmark benchmark = new Benchmark();
	}

	/* now we will parse the command line and assign all global parameters to
	 * our config object */
	public void parseCommandLine(String[] args)
	{
		/* we have to parse the command line now */
		CmdLineParser parser = new CmdLineParser();

		/* parameters needed to establish a connection */
		CmdLineParser.Option url = parser.addStringOption('u', "url");

		/* parameters related to the benchmark itself */
		CmdLineParser.Option concurrency = parser.addIntegerOption('c', "concurrency");
		CmdLineParser.Option querydir = parser.addStringOption('q', "querydir");
		CmdLineParser.Option resultdir = parser.addStringOption('r', "resultdir");
		CmdLineParser.Option numberofruns = parser.addIntegerOption('n', "numberofruns");
		CmdLineParser.Option dbtype = parser.addStringOption('t', "dbtype");

		try 
		{
	        	parser.parse(args);

			/* now we can assign the parameters to our global config object */
			Config.url = (String) parser.getOptionValue(url);
			Config.concurrency = ((Integer) parser.getOptionValue(concurrency)).intValue();
			Config.querydir = (String) parser.getOptionValue(querydir);
			Config.resultdir = (String) parser.getOptionValue(resultdir);
			Config.numberofruns = ((Integer) parser.getOptionValue(numberofruns)).intValue();
			Config.dbtype = (String) parser.getOptionValue(dbtype);
		}
		catch ( Exception e ) 
		{
			System.out.println("Usage: -u url -c concurrency -q querydir -r resultdir -n numberofruns -t pgsql/mysql");

			LogUtils.exitError("cannot parse command line: " + e.getMessage());
		}
	}

}
