package benchmark;

import java.io.*;

public class ReportQuery
{
	FileWriter 	out;
	boolean		status = true;

	public ReportQuery(String dbtype)
	{
		LogUtils.Elog("opening output file ...");

		try
		{
			out = new FileWriter(Config.resultdir + "/" + dbtype + "_"
				+ System.currentTimeMillis() + ".sql", true);
		}
		catch (Exception e)
		{
			LogUtils.exitError("cannot open output file: " + e.getMessage());
		}
	}

	/* report one query to the log */
	public void reportQuery(String file, long diff, int threadid, int active)
	{
		while	(status == false)
		{
			/* we got to wait */
		}

		status = false;

		try
		{
			String sql = "INSERT INTO t_benchmark (tstamp, file, threadid, diff, active, dbtype) VALUES (now(), '" 
				+ file + "', '" + threadid + "', '" + diff + "', '" + active 
				+ "', '" + Config.dbtype + "' ); \n";
			out.write(sql);
		}
		catch (Exception e)
		{
			LogUtils.exitError("cannot write logging information: " + e.getMessage());
		}

		status = true;
	}

	/* close report */
	public void closeReport()
	{
		try
		{
			out.flush();
			out.close();
		}
		catch (Exception e)
		{
			LogUtils.exitError("cannot close logfile: " + e.getMessage());
		}
	}
}

