package benchmark;

import java.sql.*;
import java.util.*;

public class ClientThread extends Thread
{
	/* a connection to the database */
	Connection	conn = null;

	/* a hashtable storing all those queries */
	Hashtable	queries = null;

	/* statement and resultset */
	Statement	stmt = null;
	ResultSet	result = null;

	/* random generator for random values */
	Random		generator;

	/* the number of the current thread */
	int		threadid = 0;

	/* this object will hold one connection to the database.
	 * various instances of this object will be running. */
	public ClientThread(Hashtable queries, int threadid)
	{
		/* it is time to connect to the database now */
		String	connect_string;
		String	driver = null;
	
		this.queries 	= queries;
		this.threadid 	= threadid;

		/* init random generator */
		generator = new Random(153432421);

		/* we try to find out which driver we will use */
		if	(Config.dbtype.equals("pgsql"))
			driver = "org.postgresql.Driver";
		else if	(Config.dbtype.equals("mysql"))
			driver = "org.gjt.mm.mysql.Driver";
		else
			LogUtils.exitError("database not supported");

		/* now we can connect to the database */
		try
		{
			Class.forName(driver);

			conn = DriverManager.getConnection(Config.url);
			if		(conn == null)
			{
				LogUtils.exitError("invalid database handle for " + Config.url);
			}

			/* create a statement - we will use it throughout the entire thread */
			stmt = conn.createStatement();

			/* if we are the first thread we MUST perform a checkpoint */
			if	(threadid == 0)
			{
				if	(Config.dbtype.equals("pgsql"))
				{
					stmt.executeUpdate("CHECKPOINT");
					LogUtils.Elog("performaning checkpoint");	
				}
			}
		}
		catch (Exception e)
		{
			LogUtils.exitError("cannot connect to the database: " + e.getMessage());
		}
	}

	/* start the thread */
	public void run()
	{
		boolean 	status = true;
		long		start, query_start, query_end, end, diff;

		LogUtils.Elog("starting client thread: " + threadid);
		LogUtils.Elog("                  runs: " + Config.numberofruns);

		/* we want to count the number of active threads - this might be essential when running long benchmarks */
		Config.active++;

		/* loop until we finished */
		while	(status == true)
		{
			for	(int i = 0; i < Config.numberofruns; i++)
			{
				Enumeration 	keys = queries.keys();
				while 	(keys.hasMoreElements())
				{
					String file 	= (String) keys.nextElement();
					Vector query 	= (Vector) queries.get(file);

					/* we execute every query and report the time needed */
					query_start = System.currentTimeMillis();

					String q = null;
					
					/* execute query */
					try
					{
						for	(int j = 0; j < query.size(); j++)
						{	
							q = preprocessQuery( (String) query.get(j));
							stmt.execute(q);
						}
					}
					catch (Exception e)
					{
						LogUtils.Elog("cannot execute query: (" 
							+ q + ")" + e.getMessage());
						status = false;
					}	
			
					/* compute diff and log result */	
					query_end = System.currentTimeMillis();
					diff = query_end - query_start;
					Config.sqllog.reportQuery(file, diff, threadid, Config.active);

					yield();
				}
			}

			status = false;
		}

		Config.active--;

		LogUtils.Elog("stopping client thread: " + threadid);
	}

	/* put some random value into the query */
	public String preprocessQuery(String query)
	{
		/* substitute random int values */
		while	(query.indexOf("RANDOMINT") > 0)
		{
			query = query.replaceFirst("RANDOMINT", "" + Math.abs(generator.nextInt() % Config.range));
		}
		
		return query;
	}
}

