package benchmark;

import java.io.*;
import java.sql.*;
import java.util.*;

/* this class will start a set of client threads we will need 
 * to perform the actual benchmark. the basic idea is to run
 * a thread for every client. this way we can simulate any level of concurrency */
public class Benchmark
{
	/* we will use a vector to store the SQL statements 
	 * we want to execute in our database. */
	Hashtable	queries = null;

	public Benchmark()
	{
		/* now we can go ahead and load the SQL statements we are willing
		 * to run. all statements are stored inside a vector */
		queries = new Hashtable();
		loadStatements();

		/* initialize SQL log */
		Config.sqllog = new ReportQuery(Config.dbtype);

		/* now we can safely (hopefully) run our benchmark */
		runBenchmark();	
	}

	/* we allow the user to define a set of SQL queries and store them in
	 * files. every file will be treated as statement - it is better to put
	 * more than just one statement into a file to make sure that the whole
 	 * does not turn out to be a JDBC benchmark only */
	public void loadStatements()
	{
		if	(Config.querydir == null || Config.querydir.length() < 1)
			LogUtils.exitError("please define --querydir (-q)");

		/* now we will read all files in this directory ending with ".sql" */
		File f1 = new File(Config.querydir);
		FilenameFilter only = new OnlyExt("sql");
		String s[] = f1.list(only);
		Arrays.sort(s);
		LogUtils.Elog("we have found " + s.length + " SQL files");

		/* now we can loop through those fields and open each file one after the other */
		for	(int i = 0; i < s.length; i++)
		{	
			try
			{ 
				StringBuffer	tmp = new StringBuffer("");
				String		thisLine;
				
				BufferedReader in = new BufferedReader ( 
					new FileReader (Config.querydir + "/" + s[i]) );
				
				while	( (thisLine = in.readLine()) != null )
					tmp.append(thisLine);

				if	(tmp.length() > 0)
				{
					StringTokenizer tok = new StringTokenizer(tmp.toString(), ";");
					Vector 	vec = new Vector();
					int 	counter = 0;
					while	(tok.hasMoreTokens())
					{
						String l = tok.nextToken();
						if	(l.length() > 3)
						{
							vec.add(counter, l);
							counter++;
						}
					}
					queries.put(s[i], vec);
				}
			}
			catch (Exception e)
			{
				LogUtils.exitError("cannot read query file: " + e.getMessage());
			}
		}
	}

	/* starting the benchmark */
	public void runBenchmark()
	{
		ClientThread[]  threads = new ClientThread[Config.concurrency];

		/* now we will start a ClientThread for every "user"
 		 * IMPORTANT: we will run the clients in a separate thread
		 * 	      we will do this to reduce the impact of 
		 *	      creating the connection */
		for	(int i = 0; i < Config.concurrency; i++)
			threads[i] = new ClientThread(queries, i);

		/* now that those threads have been created we will actually 
		 * start them */
		for	(int i = 0; i < Config.concurrency; i++)
			threads[i].start();

		/* no we have to wait until all threads have finished */
		while	(Config.active > 0)
		{
			try
			{
				Thread.sleep(100);
			}
			catch (Exception e)
			{

			}
		}

		Config.sqllog.closeReport();	

		LogUtils.Elog("benchmark finished ...");
	}
}

/* read files according to a certain pattern */
class OnlyExt 
	implements FilenameFilter
{
	String ext;
		
	public OnlyExt(String ext)
	{ 
		this.ext = "." + ext; 
	}
		
	public boolean accept(File dir, String name)
	{ 
		return name.endsWith(ext); 
	}
}

