/*-------------------------------------------------------------------------
 *
 * walsender.h
 *	  Exports from postmaster/walsender.c.
 *
 * Portions Copyright (c) 1996-2008, PostgreSQL Global Development Group
 *
 * $PostgreSQL: pgsql/src/include/postmaster/walsender.h,v 1.2 2008/01/01 19:45:58 momjian Exp $
 *
 *-------------------------------------------------------------------------
 */
#ifndef _WALSENDER_H
#define _WALSENDER_H

#include "access/xlog.h"

/* global state */
extern bool	am_walsender;

/* user-settable parameters */
extern bool	XLogSyncReplication;
extern int	XLogReplicationTimeout;
extern int	WalSenderDelay;

/* main */
extern int	WalSenderMain(void);

/* communication with the other process */
extern Size WalSenderShmemSize(void);
extern void WalSenderShmemInit(void);
extern bool WalSenderRequestAdd(pid_t pid, bool wait_sending, XLogRecPtr requestLSN);
extern void WalSenderRequestRemove(pid_t pid);

/* common routines */
extern pid_t	GetWalSenderPid(void);
extern bool		WalSenderIsAlive(void);
extern void		WalSenderWakeup(void);
extern bool		CheckReplicationTimeout(int);

#endif   /* _WALSENDER_H */
