#include <stdio.h>
#ifdef __GLIBC__
#include <stdio_ext.h>
#endif

int main(void)
{
	FILE *f;
	long long i;

	f = fopen("/dev/null", "w");
	if (!f)
		return 1;
#if defined(__GLIBC__) && defined(_NO_FLOCKS)
	printf("unlocking\n");
	__fsetlocking(f, FSETLOCKING_BYCALLER);
#elif defined(_UNLOCKED)
#undef fputc
#define fputc fputc_unlocked
	printf("using fputc_unlocked\n");
#else
	printf("keep locking\n");
#endif
	for (i = 0; i < 1000000000L; i++) {
		fputc('z', f);
	}
	return 0;
}
