/*-------------------------------------------------------------------------
 *
 * conqueue.h
 *	  Concurrent Queue Structures
 *
 *-------------------------------------------------------------------------
 */

#ifdef PAR_SERVER

#ifndef CONQUEUE_H
#define CONQUEUE_H

/*
 * QUE_SIZE is maximum possible value of QUE_SIZE is 2^16-1 (65535). This is
 * determined by the 16-bit width of CQueueShmemStruct.cur_size. The minimal 
 * value of it should be at least BLCKSZ. It is because the possible inline
 * tuple size.
 */
#define QUE_SIZE		(BLCKSZ * 4)

#define	CQ_DATA			0
#define	CQ_ELOG			1
#define	CQ_DONE			2

typedef struct CQueueMember{
	uint16		len;			/* data length, including header */
	uint16		type;			/* what kind of the data */
	/* MORE DATA FOLLOWES AT THE END OF STRUCT */
}CQueueMember;

#define SizeOfCQueueMember		\
	(offsetof(CQueueMember, type) + sizeof(uint16))

/* pointer to the real data */
#define CQueueMemberData(qmem)	\
	(((char *)(qmem)) + SizeOfCQueueMember)

/* real data length */
#define CQueueMemberDataLen(qmem) \
	((qmem)->len - SizeOfCQueueMember)

extern void CQueueShmemInit(void);
extern void CQueueReset(const char *query, const char *plan);
extern void CQueueElog(int seqno, int elevel, const char *emsg);
extern void CQueuePut(int seqno, const void *item, uint16 len);
extern void CQueueDone(int seqno);
extern char *CQueueGetQuery(int seqno);
extern char *CQueueGetPlan(int seqno);
extern bool CQueueGetAll(int seqno, bool wait, void *buffer, int *real_size);

#endif /* CONQUEUE_H */

#endif /* PAR_SERVER */
