\set ECHO none
\i fti.sql
\set ECHO all

create table cds (artist varchar(255), title varchar(255));
create table cds_fti (string varchar(255), id oid) without oids;
create table cds_fti_2 (string varchar(255), word boolean, id oid) without oids;

create index cds_fti_string_idx on cds_fti (string);
create index cds_fti_2_string_idx on cds_fti_2 (string);
create index cds_fti_id_idx on cds_fti (id);
create index cds_fti_2_id_idx on cds_fti_2 (id);
create index cds_oid_idx on cds (oid);

create trigger cds_fti_trigger after update or insert or delete on cds
    for each row execute procedure fti(cds_fti, artist, title);
create trigger cds_fti_2_trigger after update or insert or delete on cds
    for each row execute procedure fti2(cds_fti_2, '1', artist, title);

insert into cds values ('John Lennon', 'Imagine');
insert into cds values ('Moby', 'Play');

select * from cds;
select * from cds_fti;
select * from cds_fti_2;
update cds set title = 'Ponder' where artist = 'John Lennon';
select * from cds_fti;
select * from cds_fti_2;
delete from cds where artist = 'Moby';
select * from cds_fti;
select * from cds_fti_2;

