#include "postgres.h"

#include <ctype.h>
#include <errno.h>
#include <math.h>
#include <limits.h>

#include "fmgr.h"
#include "uint.h"

#ifndef SHRT_MAX
#define SHRT_MAX (0x7FFF)
#endif
#ifndef SHRT_MIN
#define SHRT_MIN (-0x8000)
#endif
#ifndef INT_MAX
#define INT_MAX (0x7FFFFFFFL)
#endif
#ifndef INT_MIN
#define INT_MIN (-INT_MAX-1)
#endif
#ifndef MAX_UINT16
#define MAX_UINT16 (0xFFFF)
#endif
#ifndef MIN_UINT16
#define MIN_UINT16 (0)
#endif
#ifndef MAX_UINT32
#define MAX_UINT32 (0xFFFFFFFFL)
#endif
#ifndef MIN_UINT32
#define MIN_UINT32 (0)
#endif

/*****************************************************************************
 *	 USER I/O ROUTINES														 *
 *****************************************************************************/

/*
 *		uint2in			- converts "num" to short
 */
PG_FUNCTION_INFO_V1(uint2_in);

Datum
uint2_in(PG_FUNCTION_ARGS)
{
	char	   *num = PG_GETARG_CSTRING(0);
	char       *badp = (char *) NULL;
	long	   l = 0;
	uint16	   val;

	Assert(num);

	errno = 0;

	if (*num==0)
		l = (long) 0;
	else
		l = strtol(num, &badp, 10);
	
	if (errno && errno != EINVAL)
		elog(ERROR, "uint2in: error reading \"%s\": %m", num);
	if (badp && *badp && (*badp != '\0'))
		elog(ERROR, "uint2in: error in \"%s\": can\'t parse \"%s\"", num, badp);

	if (l < 0 || l > USHRT_MAX)
	{
		errno = ERANGE;
		elog(ERROR, "pg_atoi: error reading \"%s\": %m", num);
	}
	val = l;

	PG_RETURN_UINT16(val);
}

/*
 *		uint2out			- converts short to "num"
 */
PG_FUNCTION_INFO_V1(uint2_out);

Datum
uint2_out(PG_FUNCTION_ARGS)
{
	uint16		arg1 = PG_GETARG_UINT16(0);
	char	   *result = (char *) palloc(6);	/* 5 digits, '\0' */

	sprintf(result,"%d", arg1);
	PG_RETURN_CSTRING(result);
}
