
-- Sections
CREATE TABLE sections (
   sec_id int2 not null primary key check (sec_id > 0),
   sec_name text not null unique,
   rating int2 default 100 check (rating > 0),
   status char default 'A'
);

-- Ssubsections
CREATE TABLE subsections (
   subsec_id int2 not null primary key check (subsec_id > 0),
   subsec_name text not null,
   sec_id int2 not null references sections (sec_id),
   rating int2 default 100 check (rating > 0),
   status char default 'A',
   unique (subsec_name, sec_id)
);

-- Positions
CREATE TABLE positions (
   pos_id int2 not null primary key check (pos_id > 0),
   pos_name text not null,
   subsec_id int2 not null references subsections (subsec_id),
   age_time reltime not null,
   top_prc float not null check (top_prc >= 0 AND top_prc <= 100),
   rating int2 default 100 check (rating > 0),
   status char default 'A',
   unique (pos_name, subsec_id)
);


-- Cities
CREATE TABLE cities (
   city_id int2 not null primary key check (city_id > 0),
   city_name text not null unique,
   rating int2 default 100 check (rating > 0),
   status char default 'A'
);

-- Districts
CREATE TABLE districts (
   distr_id int2 not null primary key check (distr_id > 0),
   distr_name text not null,
   city_id int2 not null references cities (city_id),
   rating int2 default 100 check (rating > 0),
   status char default 'A',
   unique (distr_name, city_id)
);


-- Shop types
CREATE TABLE shop_types (
   type_id serial primary key,
   type_name varchar(100) not null,
   rating int2 default 100 check (rating > 0),
   status char default 'A'
);

-- Shops
CREATE TABLE shops (
   shop_id int4 not null primary key check (shop_id > 0),
   shop_type int references shop_types (type_id),
   shop_name text not null,
   distr_id int2 not null references districts (distr_id),
   address text,
   rating int2 default 100 check (rating > 0),
   status char default 'A'
);


-- Producers
CREATE TABLE producers (
   producer_id int2 not null primary key check (producer_id > 0),
   producer_name text not null unique,
   rating int2 default 100 check (rating > 0),
   status char default 'N'
);

-- Products
CREATE TABLE products (
   prod_id int4 not null primary key check (prod_id > 0),
   prod_name text not null,
   producer_id int2 not null references producers (producers_id),
   rating int2 default 100 check (rating > 0),
   status char default 'N'
);


-- Correspondents
CREATE TABLE correspondents (
   cor_id int2 not null primary key check (cor_id > 0),
   cor_name text not null,
   cor_email text not null unique,
   cor_papers text not null,
   distr_id int2 not null references districts (distr_id),
   cor_type int2 default 0,
   cor_pic char(8) not null unique,
   encoded_passwd char(13) not null,
   status char default 'A',
   last_paid date,
   money_from_prev_month float default 0
);
CREATE TABLE shop_corr (
   cor_id int2 references correspondents (cor_id),
   shop_id int2 not null references shops (shop_id),
   corr_shop int,
   primary key (cor_id, shop_id)
);

-- Money for correspondents
CREATE TABLE money4corr (
   date_i date default current_date,
   amount float not null
);


-- Raw maillog - datetime/from
CREATE TABLE raw_maillog (
   mail_id serial primary key,
   datetime_i timestamp default current_timestamp,
   cor_id int2 references correspondents (cor_id), -- may be NULL
   message_id varchar(255),
   mail_from varchar(255),
   addr_from varchar(255),
   status char default 'X'
);

-- Mail errors
CREATE TABLE corr_mail_errors (
   mail_id int references raw_maillog (mail_id),
   form_no int not null,
   status char default 'D'
);


-- Position's rating for today for every city
CREATE TABLE pos_rating (
   pos_id int2 not null references positions (pos_id),
   date_i date default current_date,
   city_id int2 not null references cities (city_id),
   rating float default 5 check (rating >= 1 and rating <= 10),
   primary key (pos_id, date_i, city_id)
);

-- Message of the day
CREATE TABLE motd (
   msg_id serial primary key,
   date_i date default current_date,
   message text not null
);


-- and finally, main Central database...
CREATE TABLE central (
   pos_id int2 not null references positions (pos_id),
   date_i abstime not null,
   weight float not null,
   price float not null,
   cur_id int2 references currencies (cur_id),
   shop_id int2 not null references shops (shop_id),
   cor_id int2 references correspondents (cor_id),
   prod_id int4 references products (prod_id),
   cor_marks float default 0,
   mail_id int references raw_maillog (mail_id),
   unit_id int not null references units (unit_id)
);
-- ...and its copy for bad data
CREATE TABLE bad_data (
   pos_id int2 not null references positions (pos_id),
   date_i abstime not null,
   weight float not null,
   price float not null,
   cur_id int2 references currencies (cur_id),
   shop_id int2 not null references shops (shop_id),
   cor_id int2 references correspondents (cor_id),
   prod_id int4 references products (prod_id),
   cor_marks float default 0,
   mail_id int references raw_maillog (mail_id),
   unit_id int not null references units (unit_id),
   status char default 'k'
);

-- Table for "today"s history
CREATE TABLE today_history (
   city_id int2 not null references cities (city_id),
   pos_id int2 not null references positions (pos_id),
   date_i abstime not null,
   weight float not null,
   min_price float not null,
   average float not null,
   max_price float not null,
   points int2 not null,
   last_update time not null,
   pred_date abstime,
   prc_change float not null
);
