CREATE TABLE tab(a INT);

BEGIN;

-- Create three rows with different cmin
INSERT INTO tab VALUES(1);
INSERT INTO tab VALUES(2);
INSERT INTO tab VALUES(3);

-- Deleting all the rows will create three combo cids with the same cmax
SAVEPOINT s; DELETE FROM tab; ROLLBACK TO SAVEPOINT s;

-- We expect all the rows to still be there after rollback
SELECT a FROM tab;

-- Try a few more rounds of deletions
SAVEPOINT s; DELETE FROM tab; ROLLBACK TO SAVEPOINT s;
SAVEPOINT s; DELETE FROM tab; ROLLBACK TO SAVEPOINT s;
SAVEPOINT s; DELETE FROM tab; ROLLBACK TO SAVEPOINT s;

-- Still there?
SELECT a FROM tab;

COMMIT;

-- Still there?
SELECT a FROM tab;

DROP TABLE tab;
