import java.net.*;
import java.io.*;

/*
	Requirements for ojbects to be serialized into postgres:

	1) Must have a no-arg constructor
	2) Must have class name that is all lowercase since database
		table names are case-insensitive but stored as lowercase.
	3) Should probably only contain only simple fields like String and the 
		java primitive types since the recursive stuff might not work.
	4) Must implement the Serializable interface even though I
		do not know how it is used here.
	5) Should have a "public int oid;" field that is initialized
		to 0.  The oid field should be for read-only and is
		used for identifying the row to be updated during updates.
		If the oid field is absent, then all calls of
		setObject() on it in prepared statements cause the
		insertion of the object again and again.
*/

public class myurl implements Serializable {
	public int oid;
	public String url;

	// this no-arg constructor is required in order for
	// Class.newInstance() to work in Serialize.getObject()
	public myurl() { }

	public myurl( String url ) {
		this.url = url; oid = 0;
	}
}
