-- $Revision$
-- $Name$
-- $Date$
-- $Author$
-- $State$
-- $Locker$
-- $Source$
-- $Header$

-- Copyright (C) 2004 lyrix community

-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

-- http://www.gnu.org/licenses/gpl.html


\echo
\echo 'Create table t_songs...'
\echo '======================='
\echo '(t_songs.pgsql runnning)'
\echo


CREATE TABLE t_songs (
   song_id
      INTEGER
      PRIMARY KEY
      DEFAULT NEXTVAL('s_t_songs_pkey'),
   song_title
      TEXT
      NOT NULL,
   year_of_composition
      SMALLINT,
   year_of_first_publication
      SMALLINT,
   entry_timestamp
      TIMESTAMP WITH TIME ZONE
      NOT NULL
      DEFAULT CURRENT_TIMESTAMP,
   predecessor_id
      INTEGER,
   show
      BOOLEAN
      NOT NULL
      DEFAULT TRUE,
   CONSTRAINT song_title_ukey
      UNIQUE(song_title, entry_timestamp),
   CONSTRAINT predecessor_song_id_fkey
      FOREIGN KEY (predecessor_id)
      REFERENCES t_songs (song_id)
      ON DELETE RESTRICT
      ON UPDATE RESTRICT
);

COMMENT ON TABLE t_songs IS '
   table that stores information on songs
';

COMMENT ON COLUMN t_songs.show IS '
   flag that defines if an entry must or must not be shown in "v_songs"
';

\echo
\echo '(t_songs.pgsql finished)'
\echo

-- $Log$


