-- $Revision$
-- $Name$
-- $Date$
-- $Author$
-- $State$
-- $Locker$
-- $Source$
-- $Header$

-- Copyright (C) 2004 lyrix community

-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

-- http://www.gnu.org/licenses/gpl.html


\echo
\echo 'Create table t_song_comments...'
\echo '==============================='
\echo '(t_song_comments.pgsql runnning)'
\echo


CREATE TABLE t_song_comments (
   song_comment_id
      INTEGER
      PRIMARY KEY
      DEFAULT NEXTVAL('s_t_song_comments_pkey'),
   song_id
      INTEGER
      NOT NULL,
   thread_id
      INTEGER
      NOT NULL
      DEFAULT NEXTVAL('s_t_song_comments_thread_id'),
   predecessor_id
      INTEGER,
   comment
      TEXT
      NOT NULL,
   entry_timestamp
      TIMESTAMP WITH TIME ZONE
      NOT NULL
      DEFAULT CURRENT_TIMESTAMP,
   CONSTRAINT t_song_comments2_t_songs_fkey
      FOREIGN KEY (song_id)
      REFERENCES t_songs (song_id)
      ON DELETE RESTRICT
      ON UPDATE RESTRICT,
   CONSTRAINT predecessor_song_comment_id_fkey
      FOREIGN KEY (predecessor_id)
      REFERENCES t_song_comments (song_comment_id)
      ON DELETE RESTRICT
      ON UPDATE RESTRICT
);

COMMENT ON TABLE t_song_comments IS '
   table that stores comments on songs
';

COMMENT ON COLUMN t_song_comments.thread_id IS '
   Comments that are "replies" on comments or "corrections" are assigned to the
   same thread. A thread is openend by a new comment. This information is
   implicitly in predecessor_id.
';

COMMENT ON COLUMN t_song_comments.predecessor_id IS '
   defines the song_comment_id to which the current entry is a "reply" or
   "correction"
';


\echo
\echo '(t_song_comments.pgsql finished)'
\echo

-- $Log$


