-- $Revision$
-- $Name$
-- $Date$
-- $Author$
-- $State$
-- $Locker$
-- $Source$
-- $Header$

-- Copyright (C) 2004 lyrix community

-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.

-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
-- GNU General Public License for more details.

-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

-- http://www.gnu.org/licenses/gpl.html


\echo
\echo 'Create view v_song_comments...'
\echo '=============================='
\echo '(v_song_comments.pgsql runnning)'
\echo


CREATE OR REPLACE VIEW v_song_comments AS
   SELECT
      vs.song_id,
      vs.song_title,
      vs.year_of_composition,
      vs.year_of_first_publication,
      vs.entry_timestamp AS song_entry_timestamp,
      tsc.comment,
      tsc.song_comment_id,
      tsc.thread_id,
      tsc.predecessor_id,
      tsc.entry_timestamp AS comment_entry_timestamp
   FROM
      v_songs vs,
      t_song_comments tsc
   WHERE
      vs.song_id = tsc.song_id
;

COMMENT ON VIEW v_song_comments IS '
   wrapper only showing entries of "t_songs" that have "show" set to true,
   joining the comments
';


\echo
\echo '(v_song_comments.pgsql finished)'
\echo

-- $Log$


