

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

import org.postgresql.PostgresqlDataSource;

public class Test
{
	public static void main( String args[] ) throws Exception
	{
		try
		{
			// setup data source, just replace with correct info
			// the db should have a table named some_table
			// with a int_value column of type INT
			PostgresqlDataSource xaDs = new PostgresqlDataSource();
			xaDs.setUser( "<user>" );
			xaDs.setPassword( "<pwd>" );
			xaDs.setDatabaseName( "<db>" );
			xaDs.setServerName( "<host>" );
			
			// get a XAConnection that we try to reuse
			XAConnection xaCon = xaDs.getXAConnection();
			// since we execute lots of transactions sequentially we could
			// just request a new XAConnection but either way we get an 
			// exception
			// see Sun JTA specifaction page 24-25, this is what we try to
			// simluate 1000 times.
			for ( int i = 0; i < 999; i++ )
			{
				// start transaction
				XAResource xaRs = xaCon.getXAResource();
				Xid xid = new org.jboss.tm.XidImpl();
				xaRs.start( xid, javax.transaction.xa.XAResource.TMNOFLAGS );
				
				// get connection and perform some operaiton
				Connection conn = xaCon.getConnection();
				java.sql.Statement stmnt = conn.createStatement();
				stmnt.executeUpdate( "INSERT INTO some_table (int_value) " +
					"VALUES (" + i + ");" );
				conn.close();

				// commit and end transaction
				xaRs.end( xid, javax.transaction.xa.XAResource.TMSUCCESS );
				// one-phase commit
				xaRs.commit( xid, true );
				
				// just to see how far we get
				System.out.print( "." );
				// if sleep then it works, else we get exception
				// Thread.currentThread().sleep( 1000 );
			}
		}
		catch ( Exception e )
		{
			System.out.println( "" + e );
			e.printStackTrace();
		}
	}
}