create extension decoder_stats;
create table test (c int);

-- function to wait for counters to advance
CREATE FUNCTION wait_for_decode_stats() RETURNS void AS $$
DECLARE
  start_time timestamptz := clock_timestamp();
  updated bool;
BEGIN
  -- we don't want to wait forever; loop will exit after 30 seconds
  FOR i IN 1 .. 300 LOOP

    -- check to see if all updates have been reset/updated
    SELECT (total_txns > 0)
    INTO updated
    FROM pg_stat_replication_slots WHERE slot_name='test_slot';

    exit WHEN updated;

    -- wait a little
    perform pg_sleep_for('100 milliseconds');

    -- reset stats snapshot so we can test again
    perform pg_stat_clear_snapshot();

  END LOOP;

  -- report time waited in postmaster log (where it won't change test output)
  RAISE LOG 'wait_for_decode_stats delayed % seconds',
    extract(epoch from clock_timestamp() - start_time);
END
$$ LANGUAGE plpgsql;

select 'init' from pg_create_logical_replication_slot('test_slot', 'decoder_stats');
select pg_current_wal_lsn() as start_lsn; \gset

-- actual test workload
begin;
insert into test select generate_series(1, 10000);
savepoint s1;
insert into test select generate_series(1, 10000);
savepoint s2;
insert into test select generate_series(1, 10000);
commit;

select pg_current_wal_lsn() as end_lsn; \gset

-- decode
--set logical_decoding_work_mem to '64kB';
select pg_logical_slot_peek_changes('test_slot', null, null);
select wait_for_decode_stats();

-- check stats
select * from decoder_stats();
select * from pg_stat_replication_slots;
select * from mystats('test_slot');
select pg_size_pretty(:'end_lsn'::pg_lsn - :'start_lsn') as wal_size;
select change_type, change_bytes, total_bytes from mystats('test_slot');

-- cleanup
select pg_drop_replication_slot('test_slot');
